#include <bits/extc++.h>

using namespace std;

using ll = long long;
using ull = unsigned long long;
using ii = pair<ll, ll>;
using vi = vector<ll>;
using vii = vector<ii>;
using vb = vector<bool>;
using vc = vector<char>;
using vvi = vector<vi>;
using vvc = vector<vc>;
using vvii = vector<vii>;
using vvb = vector<vector<bool>>;

template<typename T, typename Y>
istream& operator>>(istream& s, pair<T, Y>& v) {
  return s >> v.first >> v.second;
}

template<typename T>
istream& operator>>(istream& s, vector<T>& v) {
  for (auto& e : v) s >> e;
  return s;
}

template<typename T>
ostream& operator<<(ostream& s, const vector<T>& v) {
  for (const auto& e : v) s << e << ' ';
  return s;
}

bool solve();

int main() {
#ifdef DEBUG
  freopen("../in.txt", "r", stdin);
  freopen("../out.txt", "w", stdout);
#endif

  ios_base::sync_with_stdio(false);
  cin.tie(nullptr);
  cout.setf(ios::fixed);
  cout.precision(20);

  ll t;
  cin >> t;
  while (solve());
}

bool solve() {
  ll x, y;
  if (!(cin >> x >> y)) return false;

  ll best_k = 1e18;

  if (x == y) {
    cout << 0 << endl;
    return true;
  }

  for (ll d = 1; d * d <= (y - x); ++d) {
    if ((y - x) % d == 0) {
      for (ll k : {x - d, x - (y - x) / d}) {
        if (k < x && k >= 0) {
          assert((y - k) % (x - k) == 0);
          if (k < best_k) best_k = k;
        }
      }
    }
  }

  cout << best_k << endl;

  return true;
}